/*
 * Decompiled with CFR 0.152.
 */
package panther.pep;

import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ProgressMonitor;
import panther.util.general.Constants;
import pse.pt.PacketTracer;
import pse.util.general.Utilities;
import skeletonapplet.AbstractDelegatorApplet;
import skeletonapplet.CheckEnvironmentAppletWorker;
import skeletonapplet.JreDatum;
import skeletonapplet.JreInfo;

public class CheckEnvironmentWorker
implements CheckEnvironmentAppletWorker {
    protected AbstractDelegatorApplet applet;
    protected ProgressMonitor monitor;
    protected TimerTask updateTask;
    protected Timer updateTimer;
    protected long overallTimeLimit;
    protected PacketTracer packetTracer;
    protected String[] allowedPtVersions;
    protected String[] disallowedPtVersions;
    protected String[] disallowedBrowserNames;
    protected String browserCodeName;

    public CheckEnvironmentWorker() {
        JreInfo.soleInstance().ptaBuild().setValueOkay("12.009");
    }

    public void setApplet(AbstractDelegatorApplet abstractDelegatorApplet) {
        this.applet = abstractDelegatorApplet;
    }

    public void instanceCreation() {
    }

    public void init() {
        String string;
        try {
            string = this.applet.getParameter("allowedptversions", "5.2.0.007;5.2.0.008;5.2.0.009;5.2.0.01;5.2.1;5.3");
            this.allowedPtVersions = string.split(";");
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
            this.allowedPtVersions = Constants.ALLOWED_PT_VERSIONS;
        }
        try {
            string = this.applet.getParameter("disallowedptversions", "");
            this.disallowedPtVersions = string == null || string.trim().length() == 0 ? new String[0] : string.split(";");
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
            this.disallowedPtVersions = Constants.DISALLOWED_PT_VERSIONS;
        }
        try {
            string = this.applet.getParameter("disallowedbrowsernames", "opera");
            this.disallowedBrowserNames = string == null || string.trim().length() == 0 ? new String[0] : string.split(";");
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
            this.disallowedBrowserNames = Constants.DISALLOWED_BROWSER_NAMES;
        }
    }

    public boolean isActive() {
        return true;
    }

    public void performComplete() {
    }

    public void performInterrupt() {
    }

    public void performQuit() {
    }

    public void start() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public String getBuildVersion() {
        return "12.009";
    }

    public Date getLoadDate() {
        return Constants.LOAD_DATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTests() {
        try {
            this.checkBrowser();
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
        }
        try {
            this.checkPacketTracerVersion();
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
        }
        finally {
            this.closeEverything();
        }
    }

    protected boolean browserNameMatches(String string, String[] stringArray) {
        if (string == null || stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    protected void checkBrowser() throws Exception {
        String string = this.applet.getParameter("browsername");
        skeletonapplet.Utilities.logPrintln("\t\tbrowserName = " + string);
        if (string == null || string.trim().length() == 0) {
            string = "Undetermined";
        }
        JreInfo.soleInstance().browserName().setValue(string);
        if (this.browserNameMatches(string, this.disallowedBrowserNames)) {
            JreInfo.soleInstance().browserName().setStatus(JreDatum.STATUS_ERROR, "Your browser (\"" + string + "\") <b>cannot</b> be used for Cisco Packet Tracer Skills Assessments!  We suggest you try Firefox or Internet Explorer instead.");
        }
    }

    protected void checkPacketTracerVersion() throws Exception {
        int n = 39000;
        int n2 = n + 1000;
        int n3 = PacketTracer.findOpenIpcPort(n, n2);
        if (n3 <= 0) {
            JreInfo.soleInstance().ptPortsAvailable().setValue("No", JreDatum.STATUS_ERROR, "No open, available ports were found between " + n + " and " + n2 + ".  Review your security settings to ensure that a number of ports in this range are available for connection.");
            JreInfo.soleInstance().ptVersion().setValue("Unavailable", JreDatum.STATUS_ERROR, "Unable to determine PT version because of the lack of open, accessible ports.");
            return;
        }
        JreInfo.soleInstance().ptPortsAvailable().setValueOkay("Yes");
        this.packetTracer = new PacketTracer("localhost", n3, true);
        this.packetTracer.launch(this.applet.getLocator());
        this.packetTracer.connect();
        String string = this.packetTracer.getVersion();
        JreInfo.soleInstance().ptVersion().setValue(string);
        boolean bl = false;
        if (string != null) {
            int n4;
            for (n4 = 0; n4 < this.allowedPtVersions.length; ++n4) {
                if (!string.startsWith(this.allowedPtVersions[n4])) continue;
                bl = true;
            }
            for (n4 = 0; n4 < this.disallowedPtVersions.length; ++n4) {
                if (!string.startsWith(this.disallowedPtVersions[n4])) continue;
                bl = false;
            }
        }
        if (!bl) {
            String string2 = this.formatAsString(this.allowedPtVersions);
            String string3 = this.formatAsString(this.disallowedPtVersions);
            String string4 = string3 == null ? "" : "  They MUST NOT begin with one of the following: " + string3 + ".";
            String string5 = this.applet.getParameter("minimumptversion");
            String string6 = string5 == null ? "  Valid versions must begin with one of the following: " + string2 + "." : "  Your Packet Tracer version should be at least " + string5 + ".";
            JreInfo.soleInstance().ptVersion().setStatus(JreDatum.STATUS_ERROR, "The Cisco Packet Tracer program determined by your operating system environment variables has an invalid version of \"" + string + "\"." + string6 + string4 + "  You must upgrade your Packet Tracer version before you can take a Packet Tracer Skills Assessment.");
        } else {
            JreInfo.soleInstance().ptVersion().setStatus(JreDatum.STATUS_OK);
        }
    }

    protected String formatAsString(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    protected void closeEverything() {
        if (this.packetTracer != null) {
            try {
                this.packetTracer.shutDown();
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
        }
        if (this.updateTimer != null) {
            try {
                this.updateTimer.cancel();
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
        }
        if (this.monitor != null) {
            try {
                this.monitor.close();
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
        }
    }
}

